/*
 * Decompiled with CFR 0.152.
 */
package com.rcx.materialis.modifiers;

import com.rcx.materialis.datagen.MaterialisModifiers;
import com.rcx.materialis.util.MaterialisPacketHandler;
import com.rcx.materialis.util.PacketTerraBeam;
import java.util.Random;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.ModList;
import slimeknights.mantle.util.OffhandCooldownTracker;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.modifiers.ability.tool.OffhandAttackModifier;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.entity.EntityManaBurst;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.item.ModItems;

public class TerrabeamModifier
extends Modifier {
    public static boolean enabled = ModList.get().isLoaded("botania");
    public static int MANA_PER_BEAM = 100;
    public static float CHANCE = 0.4f;
    public static Random rand = new Random();

    public TerrabeamModifier() {
        if (enabled) {
            MinecraftForge.EVENT_BUS.addListener(this::leftClick);
        }
    }

    private void leftClick(PlayerInteractEvent.LeftClickEmpty event) {
        ToolStack tool;
        if (enabled && !event.getItemStack().m_41619_() && (tool = TerrabeamModifier.getHeldTool((LivingEntity)event.getEntityLiving(), (InteractionHand)InteractionHand.MAIN_HAND)) != null && tool.getModifierLevel((Modifier)this) > 0) {
            MaterialisPacketHandler.INSTANCE.sendToServer((Object)new PacketTerraBeam());
        }
    }

    public InteractionResult onToolUse(IToolStackView tool, int level, Level world, Player player, InteractionHand hand, EquipmentSlot slotType) {
        if (enabled && !tool.isBroken() && hand == InteractionHand.OFF_HAND && OffhandCooldownTracker.isAttackReady((Player)player) && OffhandCooldownTracker.getCooldown((Player)player) == 1.0f && tool.getVolatileData().getBoolean(OffhandAttackModifier.DUEL_WIELDING)) {
            BurstHandler.trySpawnBurst(player, hand, true, false);
        }
        return InteractionResult.PASS;
    }

    public int afterEntityHit(IToolStackView tool, int level, ToolAttackContext context, float damageDealt) {
        if (enabled && context.getAttacker() instanceof Player && context.isFullyCharged()) {
            BurstHandler.trySpawnBurst((Player)context.getAttacker(), context.getHand(), false, false);
        }
        return 0;
    }

    public static class BurstHandler {
        public static ItemStack sword = new ItemStack((ItemLike)ModItems.terraSword);

        public static void trySpawnBurst(Player player, InteractionHand hand, boolean nothingForFree, boolean checkCooldown) {
            int level;
            ToolStack tool;
            if (!(!enabled || player.m_21120_(hand).m_41619_() || checkCooldown && player.m_36403_(0.0f) != 1.0f || (tool = Modifier.getHeldTool((LivingEntity)player, (InteractionHand)hand)) == null || tool.getModifierLevel(MaterialisModifiers.elvenBeamModifier.get()) >= 1 || (level = tool.getModifierLevel(MaterialisModifiers.terrabeamModifier.get())) <= 0 || !((float)level * CHANCE > 1.0f) && !(rand.nextFloat() < (float)level * CHANCE))) {
                EntityManaBurst burst = BurstHandler.getBurst(player);
                player.f_19853_.m_7967_((Entity)burst);
                if (nothingForFree && !ManaItemHandler.instance().requestManaExactForTool(player.m_21205_(), player, MANA_PER_BEAM, true)) {
                    player.m_21205_().m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                }
                player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.terraBlade, SoundSource.PLAYERS, 0.4f, 1.4f);
            }
        }

        public static EntityManaBurst getBurst(Player player) {
            EntityManaBurst burst = new EntityManaBurst(player);
            float motionModifier = 7.0f;
            burst.setColor(0x20FF20);
            burst.setMana(MANA_PER_BEAM);
            burst.setStartingMana(MANA_PER_BEAM);
            burst.setMinManaLoss(40);
            burst.setManaLossPerTick(4.0f);
            burst.setGravity(0.0f);
            burst.m_20256_(burst.m_20184_().m_82490_((double)motionModifier));
            burst.setSourceLens(sword);
            return burst;
        }
    }
}

